-- [ja] 旧バージョンではDataフォルダに保存していたが公式曰く非推奨 
local function localGetSMVersion()
	local v=string.lower(ProductVersion())
	if string.find(v,"v5.0 beta 1",0,true) then
		return 10;
	elseif string.find(v,"v5.0 beta",0,true) then
		return 20;
	elseif string.find(v,"v5.0 alpha 1",0,true) then
		return 1;
	elseif string.find(v,"v5.0 alpha 2",0,true) then
		return 2;
	elseif string.find(v,"v5.0 alpha 3",0,true) then
		return 3;
	elseif string.find(v,"v5.0 preview",0,true) then
		return 0;
	end;
	return 20;
end;

local PrefOldPath = "Data/UserPrefs/D3NEX_MAXIMUM/";
local PrefPath = "Save/UserPrefs/D3NEX_MAXIMUM/";
local PrefPathF = (localGetSMVersion()>=20) and "Save/UserPrefs/_fallback/" or "Data/UserPrefs/_fallback/";

--[[ begin internal stuff; no need to edit below this line. ]]

-- Local internal function to write envs. ___Not for themer use.___
local function WriteEnv(envName,envValue)
	return setenv(envName,envValue)
end

function ReadPrefFromFile_Theme(name)
	local f = RageFileUtil.CreateRageFile()
	local fullFilename = PrefPath..name..".cfg"
	local fullOldFilename = PrefOldPath..name..".cfg"
	local option

	if f:Open(fullFilename,1) then
		option = tostring( f:Read() )
		WriteEnv(name,option)
		f:destroy()
		return option
	elseif f:Open(fullOldFilename,1) then
		option = tostring( f:Read() )
		WriteEnv(name,option)
		f:destroy()
		return option
	else
		local fError = f:GetError()
		Trace( "[FileUtils] Error reading ".. fullFilename ..": ".. fError )
		f:ClearError()
		f:destroy()
		return nil
	end
end

function WritePrefToFile_Theme(name,value)
	local f = RageFileUtil.CreateRageFile()
	local fullFilename = PrefPath..name..".cfg"

	if f:Open(fullFilename, 2) then
		f:Write( tostring(value) )
		WriteEnv(name,value)
	else
		local fError = f:GetError()
		Trace( "[FileUtils] Error writing to ".. fullFilename ..": ".. fError )
		f:ClearError()
		f:destroy()
		return false
	end

	f:destroy()
	return true
end

function WritePrefToFile_fallback(name,value)
	local f = RageFileUtil.CreateRageFile()
	local fullFilename = PrefPathF..name..".cfg"

	if f:Open(fullFilename, 2) then
		f:Write( tostring(value) )
		WriteEnv(name,value)
	else
		local fError = f:GetError()
		Trace( "[FileUtils] Error writing to ".. fullFilename ..": ".. fError )
		f:ClearError()
		f:destroy()
		return false
	end

	f:destroy()
	return true
end

--[[ end internal functions; still don't edit below this line ]]

function GetUserPref_Theme(name)
	if name=="ExLifeLevel" then
		return getenv("ExLifeLevel");
	end;
	return ReadPrefFromFile_Theme(name)
end

function SetUserPref_Theme(name,value)
	if name=="ExLifeLevel" then
		setenv("ExLifeLevel",value);
		return
	end;
	return WritePrefToFile_Theme(name,value)
end

function SetUserPref_fallback(name,value)
	return WritePrefToFile_fallback(name,value)
end
-- [ja] ここまで_fallbackから抜き出し＋命令や変数名が被らないように修正 

local function OptionNameString(str)
	return THEME:GetString('OptionNames',str)
end

-- Example usage of new system (not really implemented yet)
function InitUserPrefs()
	local Prefs =
	{
--		AutoSetStyle = 'Off',
		NotePosition = 'Normal',
		FlashyCombos = 'On',
		ComboUnderField = 'True',
	}
	for k, v in pairs(Prefs) do
		-- kind of xxx
		-- local GetPref = type(v) == "boolean" and GetUserPrefB or GetUserPref
		if GetUserPref(k) == nil then
			SetUserPref_fallback(k, v)
		end
	end
end

InitUserPrefs();


function InitUserPrefs_Theme()
	local Prefs = {
		DF_AutoSetStyle = 'On',
		DF_ComboUnderField = 'True',
		DF_FlashyCombos = 'On',
		UserScreenFilterP1 = 'Off',
		UserScreenFilterP2 = 'Off',
		UserBGScale = 'Fit',
		UserBGAtoLua = 'Auto',
		UserHoldJudgmentType = 'DDR',
		UserDifficultyName = 'D3NEX',
		UserDifficultyColor = 'DDR',
		UserJudgementLabel = 'D3NEX',
		UserMineHitMiss = 'false',
		UserHaishin = 'Off',
		UserScoreMode = 'Default',
		UserSpeedAssistP1 = 'Off',
		UserSpeedAssistP2 = 'Off',
		UserTargetP1 = 'Off',
		UserTargetP2 = 'Off',
		UserCustomScore = 'Off',
		UserMinCombo = 'TapNoteScore_W3',
		UserWheelMode = 'Jacket->BG',
		UserShowCaloriesP1 = 'Off',
		UserShowCaloriesP2 = 'Off',
		UserHoldCheckPoints = 'Off',
		UserComboBreakOnNG = 'Off',
		UserResultBGM = 'On',
		UserComiket = 'On'
	}
	for k, v in pairs(Prefs) do
		-- kind of xxx
		-- local GetPref = type(v) == "boolean" and GetUserPrefB or GetUserPref
		if GetUserPref_Theme(k) == nil then
			SetUserPref_Theme(k, v)
		end
	end
end

InitUserPrefs_Theme();

-- [ja] 追加部分

function UserLightEffect()
	local t = {
		Name = "UserLightEffect",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = { 'Never','Auto','Always' },
		LoadSelections = function(self, list, pn)
			if GetUserPref_Theme("UserLightEffect") ~= nil then
				if (GetUserPref_Theme("UserLightEffect")=='Auto') then
					list[2] = true
				elseif (GetUserPref_Theme("UserLightEffect")=='Always') then
					list[3] = true
				else
					list[1] = true
				end
			else
				SetUserPref_Theme("UserLightEffect", 'Auto');
				list[2] = true
			end
		end,
		SaveSelections = function(self, list, pn)
			local val;
			if list[1] then val='Never'; elseif list[2] then val='Auto'; else val='Always'; end;
			SetUserPref_Theme("UserLightEffect", val)
			MESSAGEMAN:Broadcast("PreferenceSet", { Message == "Set Preference" })
			THEME:ReloadMetrics()
		end
	}
	setmetatable(t, t)
	return t
end

function UserHoldJudgmentType()
	local t = {
		Name = "UserHoldJudgmentType",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = { 'StepMania','DDR' },
		LoadSelections = function(self, list, pn)
			if GetUserPref_Theme("UserHoldJudgmentType") ~= nil then
				if (GetUserPref_Theme("UserHoldJudgmentType")=='DDR') then
					list[2] = true
				else
					list[1] = true
				end
			else
				SetUserPref_Theme("UserHoldJudgmentType", 'StepMania');
				list[1] = true
			end
		end,
		SaveSelections = function(self, list, pn)
			local val = list[2] and 'DDR' or 'StepMania';
			SetUserPref_Theme("UserHoldJudgmentType", val)
			MESSAGEMAN:Broadcast("PreferenceSet", { Message == "Set Preference" })
			THEME:ReloadMetrics()
		end
	}
	setmetatable(t, t)
	return t
end

function UserHoldCheckPoints()
	local t = {
		Name = "UserHoldCheckPoints",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = { 'Off','On' },
		LoadSelections = function(self, list, pn)
			if GetUserPref_Theme("UserHoldCheckPoints") ~= nil then
				if (GetUserPref_Theme("UserHoldCheckPoints")=='On') then
					list[2] = true
				else
					list[1] = true
				end
			else
				SetUserPref_Theme("UserHoldCheckPoints", 'Off');
				list[1] = true
			end
		end,
		SaveSelections = function(self, list, pn)
			local val = list[2] and 'On' or 'Off';
			SetUserPref_Theme("UserHoldCheckPoints", val)
			MESSAGEMAN:Broadcast("PreferenceSet", { Message == "Set Preference" })
			THEME:ReloadMetrics()
		end
	}
	setmetatable(t, t)
	return t
end

function UserBGAtoLua()
	local t = {
		Name = "UserBGAtoLua",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = { 'Never','Auto','Always' },
		LoadSelections = function(self, list, pn)
			if GetUserPref_Theme("UserBGAtoLua") ~= nil then
				if (GetUserPref_Theme("UserBGAtoLua")=='Auto') then
					list[2] = true
				elseif (GetUserPref_Theme("UserBGAtoLua")=='Always') then
					list[3] = true
				else
					list[1] = true
				end
			else
				SetUserPref_Theme("UserBGAtoLua", 'Auto');
				list[2] = true
			end
		end,
		SaveSelections = function(self, list, pn)
			local val;
			if list[1] then val='Never'; elseif list[2] then val='Auto'; else val='Always'; end;
			SetUserPref_Theme("UserBGAtoLua", val)
			MESSAGEMAN:Broadcast("PreferenceSet", { Message == "Set Preference" })
			THEME:ReloadMetrics()
		end
	}
	setmetatable(t, t)
	return t
end

function UserScreenFilter()
	local t = {
		Name = "UserScreenFilter",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = false,
		ExportOnChange = false,
		Choices = { 'Off','25%','50%','75%','100%' },
		LoadSelections = function(self, list, pn)
			local nm=ToEnumShortString(pn);
			if PROFILEMAN:GetNumLocalProfiles()>0
				and (PROFILEMAN:GetProfile(PLAYER_1):GetDisplayName() ~= PROFILEMAN:GetProfile(PLAYER_2):GetDisplayName()) then
				for i=1,PROFILEMAN:GetNumLocalProfiles() do
					if PROFILEMAN:GetProfile(pn):GetDisplayName()==PROFILEMAN:GetLocalProfileFromIndex(i-1):GetDisplayName() then
						nm="["..PROFILEMAN:GetLocalProfileIDFromIndex(i-1).."]";
						break
					end;
				end;
			end;
			if GetUserPref_Theme("UserScreenFilter" .. nm) ~= nil then
				local bShow=GetUserPref_Theme("UserScreenFilter" .. nm);
				if bShow == 'Off' then
					list[1] = true
				elseif bShow == '25%' then
					list[2] = true
				elseif bShow == '50%' then
					list[3] = true
				elseif bShow == '75%' then
					list[4] = true
				else
					list[5] = true
				end;
			else
				list[1] = true
			end
		end,
		SaveSelections = function(self, list, pn)
			local nm=ToEnumShortString(pn);
			if PROFILEMAN:GetNumLocalProfiles()>0
				and (PROFILEMAN:GetProfile(PLAYER_1):GetDisplayName() ~= PROFILEMAN:GetProfile(PLAYER_2):GetDisplayName()) then
				for i=1,PROFILEMAN:GetNumLocalProfiles() do
					if PROFILEMAN:GetProfile(pn):GetDisplayName()==PROFILEMAN:GetLocalProfileFromIndex(i-1):GetDisplayName() then
						nm="["..PROFILEMAN:GetLocalProfileIDFromIndex(i-1).."]";
						break
					end;
				end;
			end;
			local bSave;
			if list[1] then
				bSave='Off';
			elseif list[2] then
				bSave='25%';
			elseif list[3] then
				bSave='50%';
			elseif list[4] then
				bSave='75%';
			elseif list[5] then
				bSave='100%';
			end;
			SetUserPref_Theme("UserScreenFilter" .. nm, bSave);
		end
	}
	setmetatable(t, t)
	return t
end

function UserBGScale()
	local t = {
		Name = "UserBGScale",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = { 'Fit','Cover' },
		LoadSelections = function(self, list, pn)
			if GetUserPref_Theme("UserBGScale") ~= nil then
				if GetUserPref_Theme("UserBGScale") == 'Fit' then
					list[1] = true
				else
					list[2] = true
				end;
			else
				list[1] = true
			end
		end,
		SaveSelections = function(self, list, pn)
			local bSave;
			if list[1] then
				bSave='Fit';
			else
				bSave='Cover';
			end;
			SetUserPref_Theme("UserBGScale", bSave);
		end
	}
	setmetatable(t, t)
	return t
end

function UserDifficultyName()
	local t = {
		Name = "UserDifficultyName",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = { 'StepMania','DDR','DDR EXTREME','DDR SuperNOVA',"D3NEX" },
		LoadSelections = function(self, list, pn)
			if GetUserPref_Theme("UserDifficultyName") ~= nil then
				if GetUserPref_Theme("UserDifficultyName") == 'DDR' then
					list[2] = true
				elseif GetUserPref_Theme("UserDifficultyName") == 'DDR EXTREME' then
					list[3] = true
				elseif GetUserPref_Theme("UserDifficultyName") == 'DDR SuperNOVA' then
					list[4] = true
				elseif GetUserPref_Theme("UserDifficultyName") == 'D3NEX' then
					list[5] = true
				else
					list[1] = true
				end;
			else
				list[1] = true
			end
		end,
		SaveSelections = function(self, list, pn)
			local bSave;
			if list[2] then
				bSave='DDR';
			elseif list[3] then
				bSave='DDR EXTREME';
			elseif list[4] then
				bSave='DDR SuperNOVA';
			elseif list[5] then
				bSave='D3NEX';
			else
				bSave='StepMania';
			end;
			SetUserPref_Theme("UserDifficultyName", bSave);
		end
	}
	setmetatable(t, t)
	return t
end

function UserDifficultyColor()
	local t = {
		Name = "UserDifficultyColor",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = { 'StepMania','DDR' },
		LoadSelections = function(self, list, pn)
			if GetUserPref_Theme("UserDifficultyColor") ~= nil then
				if GetUserPref_Theme("UserDifficultyColor") == 'DDR' then
					list[2] = true
				else
					list[1] = true
				end;
			else
				list[1] = true
			end
		end,
		SaveSelections = function(self, list, pn)
			local bSave;
			if list[2] then
				bSave='DDR';
			else
				bSave='StepMania';
			end;
			SetUserPref_Theme("UserDifficultyColor", bSave);
		end
	}
	setmetatable(t, t)
	return t
end

function UserJudgementLabel()
	local t = {
		Name = "UserJudgementLabel",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = { 'StepMania','DDR','DDR SuperNOVA','D3NEX' },
		LoadSelections = function(self, list, pn)
			if GetUserPref_Theme("UserJudgementLabel") ~= nil then
				if GetUserPref_Theme("UserJudgementLabel") == 'DDR' then
					list[2] = true
				elseif GetUserPref_Theme("UserJudgementLabel") == 'DDR SuperNOVA' then
					list[3] = true
				elseif GetUserPref_Theme("UserJudgementLabel") == 'D3NEX' then
					list[4] = true
				else
					list[1] = true
				end;
			else
				list[1] = true
			end
		end,
		SaveSelections = function(self, list, pn)
			local bSave;
			if list[2] then
				bSave='DDR';
			elseif list[3] then
				bSave='DDR SuperNOVA';
			elseif list[4] then
				bSave='D3NEX';
			else
				bSave='StepMania';
			end;
			SetUserPref_Theme("UserJudgementLabel", bSave);
		end
	}
	setmetatable(t, t)
	return t
end

function UserMeterType()
	local t = {
		Name = "UserMeterType",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = { 'Default','DDR (MAX12)','DDR (MAX10)','DDR X','LV100','LV20' },
		LoadSelections = function(self, list, pn)
			if GetUserPref_Theme("UserMeterType") ~= nil then
				if GetUserPref_Theme("UserMeterType") == 'DDR' then
					list[2] = true
				elseif GetUserPref_Theme("UserMeterType") == 'DDR MAX10' then
					list[3] = true
				elseif GetUserPref_Theme("UserMeterType") == 'DDR X' then
					list[4] = true
				elseif GetUserPref_Theme("UserMeterType") == 'LV100' then
					list[5] = true
				elseif GetUserPref_Theme("UserMeterType") == 'LV20' then
					list[6] = true
				else
					list[1] = true
				end;
			else
				list[1] = true
			end
		end,
		SaveSelections = function(self, list, pn)
			local bSave;
			if list[2] then
				bSave='DDR';
			elseif list[3] then
				bSave='DDR MAX10';
			elseif list[4] then
				bSave='DDR X';
			elseif list[5] then
				bSave='LV100';
			elseif list[6] then
				bSave='LV20';
			else
				bSave='Default';
			end;
			SetUserPref_Theme("UserMeterType", bSave);
		end
	}
	setmetatable(t, t)
	return t
end

function UserMineHitMiss()
	local t = {
		Name = "UserMineHitMiss",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = { 'Off','On' },
		LoadSelections = function(self, list, pn)
			if GetUserPref_Theme("UserMineHitMiss") ~= nil then
				if GetUserPref_Theme("UserMineHitMiss") == 'False'
					or GetUserPref_Theme("UserMineHitMiss") == 'Off' then
					list[1] = true
				else
					list[2] = true
				end;
			else
				list[1] = true
			end
		end,
		SaveSelections = function(self, list, pn)
			local bSave;
			if list[1] then
				bSave='Off';
			else
				bSave='On';
			end;
			SetUserPref_Theme("UserMineHitMiss", bSave);
		end
	}
	setmetatable(t, t)
	return t
end

function UserHaishin()
	local t = {
		Name = "UserHaishin",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = { 'Off','On' },
		LoadSelections = function(self, list, pn)
			if GetUserPref_Theme("UserHaishin") ~= nil then
				if GetUserPref_Theme("UserHaishin") == 'On' then
					list[2] = true
				else
					list[1] = true
				end;
			else
				list[1] = true
			end
		end,
		SaveSelections = function(self, list, pn)
			local bSave;
			if list[2] then
				bSave='On';
			else
				bSave='Off';
			end;
			SetUserPref_Theme("UserHaishin", bSave);
		end
	}
	setmetatable(t, t)
	return t
end

function UserScoreMode()
	local t = {
		Name = "UserScoreMode",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = { 'Default(9digits)','SN2(7digits)','SN2(AutoConvert)','DancePoints' },
		LoadSelections = function(self, list, pn)
			if GetUserPref_Theme("UserScoreMode") ~= nil then
				if GetUserPref_Theme("UserScoreMode") == 'DDR SuperNOVA2' then
					list[2] = true
				elseif GetUserPref_Theme("UserScoreMode") == 'SN2_AC' then
					list[3] = true
				elseif GetUserPref_Theme("UserScoreMode") == 'DancePoints' then
					list[4] = true
				else
					list[1] = true
				end;
			else
				list[1] = true
			end
		end,
		SaveSelections = function(self, list, pn)
			local bSave;
			if list[2] then
				bSave='DDR SuperNOVA2';
			elseif list[3] then
				bSave='SN2_AC';
			elseif list[4] then
				bSave='DancePoints';
			else
				bSave='Default';
			end;
			SetUserPref_Theme("UserScoreMode", bSave);
		end
	}
	setmetatable(t, t)
	return t
end

function UserSpeedAssist()
	local t = {
		Name = "UserSpeedAssist",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = false,
		ExportOnChange = false,
		Choices = { 'Off','On' },
		LoadSelections = function(self, list, pn)
			local nm=ToEnumShortString(pn);
			if PROFILEMAN:GetNumLocalProfiles()>0
				and (PROFILEMAN:GetProfile(PLAYER_1):GetDisplayName() ~= PROFILEMAN:GetProfile(PLAYER_2):GetDisplayName()) then
				for i=1,PROFILEMAN:GetNumLocalProfiles() do
					if PROFILEMAN:GetProfile(pn):GetDisplayName()==PROFILEMAN:GetLocalProfileFromIndex(i-1):GetDisplayName() then
						nm="["..PROFILEMAN:GetLocalProfileIDFromIndex(i-1).."]";
						break
					end;
				end;
			end;
			if GetUserPref_Theme("UserSpeedAssist" .. nm) ~= nil then
				if GetUserPref_Theme("UserSpeedAssist" .. nm) == 'On' then
					list[2] = true
				else
					list[1] = true
				end;
			else
				list[1] = true
			end
		end,
		SaveSelections = function(self, list, pn)
			local nm=ToEnumShortString(pn);
			if PROFILEMAN:GetNumLocalProfiles()>0
				and (PROFILEMAN:GetProfile(PLAYER_1):GetDisplayName() ~= PROFILEMAN:GetProfile(PLAYER_2):GetDisplayName()) then
				for i=1,PROFILEMAN:GetNumLocalProfiles() do
					if PROFILEMAN:GetProfile(pn):GetDisplayName()==PROFILEMAN:GetLocalProfileFromIndex(i-1):GetDisplayName() then
						nm="["..PROFILEMAN:GetLocalProfileIDFromIndex(i-1).."]";
						break
					end;
				end;
			end;
			local bSave;
			if list[2] then
				bSave='On';
			else
				bSave='Off';
			end;
			SetUserPref_Theme("UserSpeedAssist" .. nm, bSave);
		end
	}
	setmetatable(t, t)
	return t
end

function UserShowCalories()
	local t = {
		Name = "UserShowCalories",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = false,
		ExportOnChange = false,
		Choices = { 'Off','On' },
		LoadSelections = function(self, list, pn)
			local nm=ToEnumShortString(pn);
			if PROFILEMAN:GetNumLocalProfiles()>0
				and (PROFILEMAN:GetProfile(PLAYER_1):GetDisplayName() ~= PROFILEMAN:GetProfile(PLAYER_2):GetDisplayName()) then
				for i=1,PROFILEMAN:GetNumLocalProfiles() do
					if PROFILEMAN:GetProfile(pn):GetDisplayName()==PROFILEMAN:GetLocalProfileFromIndex(i-1):GetDisplayName() then
						nm="["..PROFILEMAN:GetLocalProfileIDFromIndex(i-1).."]";
						break
					end;
				end;
			end;
			if GetUserPref_Theme("UserShowCalories" .. nm) ~= nil then
				if GetUserPref_Theme("UserShowCalories" .. nm) == 'On' then
					list[2] = true
				else
					list[1] = true
				end;
			else
				list[1] = true
			end
		end,
		SaveSelections = function(self, list, pn)
			local nm=ToEnumShortString(pn);
			if PROFILEMAN:GetNumLocalProfiles()>0
				and (PROFILEMAN:GetProfile(PLAYER_1):GetDisplayName() ~= PROFILEMAN:GetProfile(PLAYER_2):GetDisplayName()) then
				for i=1,PROFILEMAN:GetNumLocalProfiles() do
					if PROFILEMAN:GetProfile(pn):GetDisplayName()==PROFILEMAN:GetLocalProfileFromIndex(i-1):GetDisplayName() then
						nm="["..PROFILEMAN:GetLocalProfileIDFromIndex(i-1).."]";
						break
					end;
				end;
			end;
			local bSave;
			if list[2] then
				bSave='On';
			else
				bSave='Off';
			end;
			SetUserPref_Theme("UserShowCalories" .. nm, bSave);
		end
	}
	setmetatable(t, t)
	return t
end

function UserTarget()
	local t = {
		Name = "UserTarget",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = false,
		ExportOnChange = false,
		Choices = { 'Off','On' },
		LoadSelections = function(self, list, pn)
			local nm=ToEnumShortString(pn);
			if PROFILEMAN:GetNumLocalProfiles()>0
				and (PROFILEMAN:GetProfile(PLAYER_1):GetDisplayName() ~= PROFILEMAN:GetProfile(PLAYER_2):GetDisplayName()) then
				for i=1,PROFILEMAN:GetNumLocalProfiles() do
					if PROFILEMAN:GetProfile(pn):GetDisplayName()==PROFILEMAN:GetLocalProfileFromIndex(i-1):GetDisplayName() then
						nm="["..PROFILEMAN:GetLocalProfileIDFromIndex(i-1).."]";
						break
					end;
				end;
			end;
			if GetUserPref_Theme("UserTarget" .. nm) ~= nil then
				if GetUserPref_Theme("UserTarget" .. nm) == 'On' then
					list[2] = true
				else
					list[1] = true
				end;
			else
				list[1] = true
			end
		end,
		SaveSelections = function(self, list, pn)
			local nm=ToEnumShortString(pn);
			if PROFILEMAN:GetNumLocalProfiles()>0
				and (PROFILEMAN:GetProfile(PLAYER_1):GetDisplayName() ~= PROFILEMAN:GetProfile(PLAYER_2):GetDisplayName()) then
				for i=1,PROFILEMAN:GetNumLocalProfiles() do
					if PROFILEMAN:GetProfile(pn):GetDisplayName()==PROFILEMAN:GetLocalProfileFromIndex(i-1):GetDisplayName() then
						nm="["..PROFILEMAN:GetLocalProfileIDFromIndex(i-1).."]";
						break
					end;
				end;
			end;
			local bSave;
			if list[2] then
				bSave='On';
			else
				bSave='Off';
			end;
			SetUserPref_Theme("UserTarget" .. nm, bSave);
		end
	}
	setmetatable(t, t)
	return t
end

function UserColor()
	local t = {
		Name = "UserColor",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = { 'Blue','Black','Ice' },
		LoadSelections = function(self, list, pn)
			if GetUserPref_Theme("UserColor") ~= nil then
				if GetUserPref_Theme("UserColor") == 'Blue' then
					list[1] = true
				elseif GetUserPref_Theme("UserColor") == 'Ice' then
					list[3] = true
				else
					list[2] = true
				end;
			else
				list[1] = true
			end
		end,
		SaveSelections = function(self, list, pn)
			local bSave;
			if list[1] then
				bSave='Blue';
			elseif list[3] then
				bSave='Ice';
			else
				bSave='Black';
			end;
			SetUserPref_Theme("UserColor", bSave);
		end
	}
	setmetatable(t, t)
	return t
end

function UserLife()
	local t = {
		Name = "UserLife",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = { 'Default','Beta' },
		LoadSelections = function(self, list, pn)
			if GetUserPref_Theme("UserLife") ~= nil then
				if GetUserPref_Theme("UserLife") == 'Beta' then
					list[2] = true
				else
					list[1] = true
				end;
			else
				list[1] = true
			end
		end,
		SaveSelections = function(self, list, pn)
			local bSave;
			if list[2] then
				bSave='Beta';
			else
				bSave='Default';
			end;
			SetUserPref_Theme("UserLife", bSave);
		end
	}
	setmetatable(t, t)
	return t
end

function UserCustomScore()
	local customscore=GetCustomScoreMode();
	local t = {
		Name = "UserCustomScore",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = { 'Off','3.9',"Hybrid","SuperNOVA2" },
		LoadSelections = function(self, list, pn)
			if customscore=="old" then
				if GetUserPref("UserPrefScoringMode") ~= nil then
					if GetUserPref("UserPrefScoringMode") == 'DDR Extreme' then
						list[2] = true
					elseif GetUserPref("UserPrefScoringMode") == 'Hybrid' then
						list[3] = true
					elseif GetUserPref("UserPrefScoringMode") == 'DDR SuperNOVA 2' then
						list[4] = true
					else
						list[1] = true
					end;
				else
					list[1] = true
				end;
			elseif customscore~="non" then
				if GetUserPref_Theme("UserCustomScore") ~= nil then
					if GetUserPref_Theme("UserCustomScore") == '3.9' then
						list[2] = true
					elseif GetUserPref_Theme("UserCustomScore") == 'Hybrid' then
						list[3] = true
					elseif GetUserPref_Theme("UserCustomScore") == 'SuperNOVA2' then
						list[4] = true
					else
						list[1] = true
					end;
				else
					list[1] = true
				end;
			else
				list[1] = true
			end;
		end,
		SaveSelections = function(self, list, pn)
			local bSaveF;
			local bSaveT;
			if customscore~="non" then
				if list[2] then
					bSaveF='DDR Extreme';
					bSaveT='3.9';
				elseif list[3] then
					bSaveF='Hybrid';
					bSaveT='Hybrid';
				elseif list[4] then
					bSaveF='DDR SuperNOVA 2';
					bSaveT='SuperNOVA2';
				else
					bSaveF='DDR Extreme';
					bSaveT='Off';
				end;
				SetUserPref("UserPrefScoringMode", bSaveF);
				SetUserPref_Theme("UserCustomScore", bSaveT);
			else
				SetUserPref("UserCustomScore", "DDR Extreme");
				SetUserPref_Theme("UserCustomScore", "Off");
			end;
		end
	}
	setmetatable(t, t)
	return t
end

function UserMinCombo()
	local t = {
		Name = "UserMinCombo",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = { 'W1','W2',"W3 (Default)","W4" },
		LoadSelections = function(self, list, pn)
			if GetUserPref_Theme("UserMinCombo") ~= nil then
				if GetUserPref_Theme("UserMinCombo") == 'TapNoteScore_W1' then
					list[1] = true
				elseif GetUserPref_Theme("UserMinCombo") == 'TapNoteScore_W2' then
					list[2] = true
				elseif GetUserPref_Theme("UserMinCombo") == 'TapNoteScore_W4' then
					list[4] = true
				else
					list[3] = true
				end;
			else
				list[3] = true
			end;
		end,
		SaveSelections = function(self, list, pn)
			local v='TapNoteScore_W3';
			if list[1] then
				v='TapNoteScore_W1';
			elseif list[2] then
				v='TapNoteScore_W2';
			elseif list[4] then
				v='TapNoteScore_W4';
			else
				v='TapNoteScore_W3';
			end;
			SetUserPref_Theme("UserMinCombo", v);
			if GetSMVersion()>40 then
				PREFSMAN:SetPreference("MinTNSToHideNotes",ToEnumShortString(v));
			end;
			
		end
	}
	setmetatable(t, t)
	return t
end

function UserWheelMode()
	local t = {
		Name = "UserWheelMode",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = { 'Jacket->Banner','Jacket->BG','Banner->Jacket','BG->Jacket' },
		LoadSelections = function(self, list, pn)
			if GetUserPref_Theme("UserWheelMode") ~= nil then
				if GetUserPref_Theme("UserWheelMode") == 'Jacket->Banner' then
					list[1] = true
				elseif GetUserPref_Theme("UserWheelMode") == 'Jacket->BG' then
					list[2] = true
				elseif GetUserPref_Theme("UserWheelMode") == 'Banner->Jacket' then
					list[3] = true
				elseif GetUserPref_Theme("UserWheelMode") == 'BG->Jacket' then
					list[4] = true
				else
					list[1] = true
				end;
			else
				list[1] = true
			end;
		end,
		SaveSelections = function(self, list, pn)
			if list[1] then
				SetUserPref_Theme("UserWheelMode", 'Jacket->Banner');
			elseif list[2] then
				SetUserPref_Theme("UserWheelMode", 'Jacket->BG');
			elseif list[3] then
				SetUserPref_Theme("UserWheelMode", 'Banner->Jacket');
			elseif list[4] then
				SetUserPref_Theme("UserWheelMode", 'BG->Jacket');
			else
				SetUserPref_Theme("UserWheelMode", 'Jacket->Banner');
			end;
		end
	}
	setmetatable(t, t)
	return t
end

function UserWheelText()
	local t = {
		Name = "UserWheelText",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = { 'None','Default','All' },
		LoadSelections = function(self, list, pn)
			if GetUserPref_Theme("UserWheelText") ~= nil then
				if GetUserPref_Theme("UserWheelText") == 'None' then
					list[1] = true
				elseif GetUserPref_Theme("UserWheelText") == 'All' then
					list[3] = true
				else
					list[2] = true
				end;
			else
				list[2] = true
			end;
		end,
		SaveSelections = function(self, list, pn)
			if list[1] then
				SetUserPref_Theme("UserWheelText", 'None');
			elseif list[3] then
				SetUserPref_Theme("UserWheelText", 'All');
			else
				SetUserPref_Theme("UserWheelText", 'Default');
			end;
		end
	}
	setmetatable(t, t)
	return t
end

--[[ end option rows ]]
-- [ja] _fallbackテーマに項目だけ残っていて設定が反映さえていないもの 

function NotePosition()
	local t = {
		Name = "NotePosition",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = { 'Normal','Lower' },
		LoadSelections = function(self, list, pn)
			if GetUserPref("NotePosition") ~= nil then
				if GetUserPref("NotePosition") == 'Normal' then
					list[1] = true
				else
					list[2] = true
				end;
			else
				list[1] = true
			end
		end,
		SaveSelections = function(self, list, pn)
			local bSave;
			if list[1] then
				bSave='Normal';
			else
				bSave='Lower';
			end;
			SetUserPref_fallback("NotePosition", bSave);
		end
	}
	setmetatable(t, t)
	return t
end

-- [ja] ｆデフォルトテーマに存在するオプション（仕様変更で消える可能性あるのでこっちに移動） 
function DF_AutoSetStyle()
	local t = {
		Name = "DF_AutoSetStyle",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = { 'Off','On' },
		LoadSelections = function(self, list, pn)
			if GetUserPref_Theme("DF_AutoSetStyle") ~= nil then
				if GetUserPref_Theme("DF_AutoSetStyle") == 'Off' then
					list[1] = true
				else
					list[2] = true
				end;
			else
				list[1] = true
			end
		end,
		SaveSelections = function(self, list, pn)
			local bSave;
			if list[1] then
				bSave='Off';
			else
				bSave='On';
			end;
			SetUserPref_Theme("DF_AutoSetStyle", bSave);
			THEME:ReloadMetrics();
		end
	}
	setmetatable(t, t)
	return t
end

function DF_ComboUnderField()
	local t = {
		Name = "DF_ComboUnderField",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = { 'False','True' },
		LoadSelections = function(self, list, pn)
			if GetUserPref_Theme("DF_ComboUnderField") ~= nil then
				if GetUserPref_Theme("DF_ComboUnderField") == tostring(false) then
					list[1] = true
				else
					list[2] = true
				end;
			else
				list[1] = true
			end
		end,
		SaveSelections = function(self, list, pn)
			local bSave;
			if list[1] then
				bSave=false;
			else
				bSave=true;
			end;
			SetUserPref_Theme("DF_ComboUnderField", bSave);
		end
	}
	setmetatable(t, t)
	return t
end

function DF_FlashyCombos()
	local t = {
		Name = "DF_FlashyCombos",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = { 'Off','On' },
		LoadSelections = function(self, list, pn)
			if GetUserPref_Theme("DF_FlashyCombos") ~= nil then
				if GetUserPref_Theme("DF_FlashyCombos") == 'Off' then
					list[1] = true
				else
					list[2] = true
				end;
			else
				list[1] = true
			end
		end,
		SaveSelections = function(self, list, pn)
			local bSave;
			if list[1] then
				bSave='Off';
			else
				bSave='On';
			end;
			SetUserPref_Theme("DF_FlashyCombos", bSave);
		end
	}
	setmetatable(t, t)
	return t
end

function UserComboBreakOnNG()
	local t = {
		Name = "UserComboBreakOnNG",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = { 'Off','On' },
		LoadSelections = function(self, list, pn)
			if GetUserPref_Theme("UserComboBreakOnNG") ~= nil then
				if GetUserPref_Theme("UserComboBreakOnNG") == 'Off' then
					list[1] = true
				else
					list[2] = true
				end;
			else
				list[1] = true
			end
		end,
		SaveSelections = function(self, list, pn)
			local bSave;
			if list[1] then
				bSave='Off';
			else
				bSave='On';
			end;
			SetUserPref_Theme("UserComboBreakOnNG", bSave);
		end
	}
	setmetatable(t, t)
	return t
end

function UserResultBGM()
	local t = {
		Name = "UserResultBGM",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = { 'Off','On' },
		LoadSelections = function(self, list, pn)
			if GetUserPref_Theme("UserResultBGM") ~= nil then
				if GetUserPref_Theme("UserResultBGM") == 'Off' then
					list[1] = true
				else
					list[2] = true
				end;
			else
				list[1] = true
			end
		end,
		SaveSelections = function(self, list, pn)
			local bSave;
			if list[1] then
				bSave='Off';
			else
				bSave='On';
			end;
			SetUserPref_Theme("UserResultBGM", bSave);
		end
	}
	setmetatable(t, t)
	return t
end

function UserComiket()
	local t = {
		Name = "UserComiket",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = true,
		ExportOnChange = false,
		Choices = { 'Off','On' },
		LoadSelections = function(self, list, pn)
			if GetUserPref_Theme("UserComiket") ~= nil then
				if GetUserPref_Theme("UserComiket") == 'On' then
					list[2] = true
				else
					list[1] = true
				end;
			else
				list[2] = true
			end
		end,
		SaveSelections = function(self, list, pn)
			local bSave;
			if list[2] then
				bSave='On';
			else
				bSave='Off';
			end;
			SetUserPref_Theme("UserComiket", bSave);
			--SetSMEXP_F((bSave=='On') and true or false);
		end
	}
	setmetatable(t, t)
	return t
end
